/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.item;

import dev.compactmods.machines.api.core.Messages;
import dev.compactmods.machines.api.core.Tooltips;
import dev.compactmods.machines.client.gui.PersonalShrinkingDeviceScreen;
import dev.compactmods.machines.core.Registration;
import dev.compactmods.machines.i18n.TranslationUtil;
import dev.compactmods.machines.room.data.CompactRoomData;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class PersonalShrinkingDevice
extends Item {
    public PersonalShrinkingDevice(Item.Properties props) {
        super(props);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (Screen.m_96638_()) {
            tooltip.add((Component)TranslationUtil.tooltip(Tooltips.Details.PERSONAL_SHRINKING_DEVICE).m_130940_(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)TranslationUtil.tooltip(Tooltips.HINT_HOLD_SHIFT).m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ServerPlayer serverPlayer;
        ServerLevel playerDim;
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (world.f_46443_ && world.m_46472_() != Registration.COMPACT_DIMENSION) {
            PersonalShrinkingDeviceScreen.show();
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (world instanceof ServerLevel && player instanceof ServerPlayer && (playerDim = (serverPlayer = (ServerPlayer)player).m_183503_()).m_46472_().equals(Registration.COMPACT_DIMENSION)) {
            if (player.m_6144_()) {
                ChunkPos machineChunk = new ChunkPos(player.m_142538_());
                CompactRoomData intern = CompactRoomData.get(playerDim);
                intern.setSpawn(machineChunk, player.m_20182_());
                MutableComponent tc = TranslationUtil.message(Messages.ROOM_SPAWNPOINT_SET).m_130940_(ChatFormatting.GREEN);
                player.m_5661_((Component)tc, true);
            } else {
                PlayerUtil.teleportPlayerOutOfMachine(playerDim, serverPlayer);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }
}

